<?php
// Datubāzes savienojuma dati
$host = 'localhost';   // Serveris, uz kuru pieslēgties
$dbname = 'EraEcho';   // Datubāzes nosaukums
$username = 'root';    // Datubāzes lietotājvārds
$password = '';        // Datubāzes lietotāja parole (šajā gadījumā tukša)

// Mēģinām izveidot savienojumu ar datubāzi, izmantojot PDO
try {
    // Izveido PDO objektu, kas nodrošina savienojumu ar MySQL datubāzi
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // Iestata kļūdu ziņojumu režīmu uz EXCEPTION, kas ļauj vieglāk izsekot kļūdām
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Ja savienojums neizdodas, atgriežam kļūdas ziņojumu JSON formātā un izbeidzam skripta izpildi
    echo json_encode(['error' => 'Connection failed: ' . $e->getMessage()]);
    exit;
}

// Pārbaudām, vai ir norādīts lietotāja ID URL
if (!isset($_GET['id'])) {
    // Ja ID nav norādīts, atgriežam kļūdas ziņojumu
    echo json_encode(['error' => 'User ID is required']);
    exit;
}

// Iegūstam lietotāja ID no URL (parasti tas ir skaitlis)
$userId = (int) $_GET['id'];

// Izpildām SQL vaicājumu, lai iegūtu lietotāja informāciju pēc ID
$stmt = $pdo->prepare("SELECT id, username, email FROM users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Ja lietotājs ir atrasts, iegūstam arī viņa pasūtījumus
if ($user) {
    // Izpildām SQL vaicājumu, lai iegūtu pasūtījumus šim lietotājam
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = ?");
    $stmt->execute([$userId]);
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Atgriežam lietotāja un pasūtījumu datus JSON formātā
    echo json_encode(['user' => $user, 'orders' => $orders]);
} else {
    // Ja lietotājs netika atrasts, atgriežam kļūdas ziņojumu
    echo json_encode(['error' => 'User not found']);
}

?>
